function p2 = fdr(p1,alpha)
% P2 = FDR(P1)
% P2 = FDR(P1,ALPHA)
%
% Performs FDR (False Discovery Rate) analysis. P1 should the vector of observed p-values.
% The function then ranges them and returns a logical vector with TRUEs where the comparison
% can be deemed significant.
% If ALPHA is ommitted, it is assumed to be == 0.05;

% Rev. Sep 19 2012

if(nargin<2)
    alpha = 0.05;
end

p1 = p1(~isnan(p1));
p2 = false(size(p1));

[p1,ind] = sort(p1);

for(q=1:length(p1))
    currentLevel = alpha/length(p1)*q;
    if(p1(q)<currentLevel)
        p2(ind(q)) = true;
    end
end

end